package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "assessmentQuestionChoiceProperties", namespace = Namespace.MobileHealthPlatform)
public class AssessmentProperties extends DomainTransferObjectCollection<AssessmentProperty> {

	private static final long serialVersionUID = 7044162064453396197L;

	@XmlElement
	public Collection<AssessmentProperty> getQuestionChoiceProperty() {
		return this;
	}

	public String getValueByPropertyName(String keyToFind) {
		for (AssessmentProperty propertyToCompare : this) {
			String key = propertyToCompare.getName();
			if (key.equals(keyToFind)) {
				return propertyToCompare.getValue();
			}
		}
		return null;
	}
}
