package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "assessmentEligibility", namespace = Namespace.MobileHealthPlatform)
public class AssessmentEligibility extends PatientData {
	private static final long serialVersionUID = -6565313362698215811L;

	@XmlElement
	private boolean eligibile;
	@XmlElement
	private int daysUntilEligible;
	@XmlElement
	private String message;

	public AssessmentEligibility() {
	}

	public AssessmentEligibility(String assessmentId, PatientIdentifier patientIdentifier) {
		this.setPatientIdentifier(patientIdentifier);
		this.setUniqueId(assessmentId);
	}

	public void setEligibility(boolean eligible) {
		this.eligibile = eligible;
	}

	public boolean isEligibile() {
		return eligibile;
	}

	public void setDaysUntilEligible(int daysUntilEligible) {
		this.daysUntilEligible = daysUntilEligible;
	}

	public int getDaysLeft() {
		return daysUntilEligible;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getMessage() {
		return message;
	}

}
