package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "assessment", namespace = Namespace.MobileHealthPlatform)
public class Assessment extends DomainTransferObject {

	private static final long serialVersionUID = 1780058061877013475L;

	@XmlElement
	private String id;
	@XmlElement
	private String uniqueTitle;
	private boolean inHealthAssessment;
	@XmlElement
	private String version;
	@XmlElement
	private String authenticationStrategy;
	@XmlElement
	private String notes;
	@XmlElement
	private String scoringAlgorithm;
	private boolean publish;
	@XmlElement(name="question")
	private AssessmentQuestions questions = new AssessmentQuestions();
	private int waitingPeriod;
	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getUniqueTitle() {
		return uniqueTitle;
	}

	public void setUniqueTitle(String uniqueTitle) {
		this.uniqueTitle = uniqueTitle;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getAuthenticationStrategy() {
		return authenticationStrategy;
	}

	public void setAuthenticationStrategy(String authenticationStrategy) {
		this.authenticationStrategy = authenticationStrategy;
	}

	public String getNotes() {
		return notes;
	}

	public void setNotes(String description) {
		this.notes = description;
	}

	public boolean getPublish() {
		return publish;
	}

	public void setPublish(boolean publish) {
		this.publish = publish;
	}

	public AssessmentQuestions getQuestions() {
		return questions;
	}

	public void setQuestions(AssessmentQuestions questions) {
		this.questions = questions;
	}

	public AssessmentQuestion getQuestionById(String questionId) {
		for (AssessmentQuestion questionToCompare : questions) {
			if (questionToCompare.getId().equals(questionId)) {
				return questionToCompare;
			}
		}
		return null;
	}

	public String getScoringAlgorithm() {
		return scoringAlgorithm;
	}

	public void setScoringAlgorithm(String scoringAlgorithm) {
		this.scoringAlgorithm = scoringAlgorithm;
	}

	public void setInHealthAssessment(boolean inHealthAssessment) {
		this.inHealthAssessment = inHealthAssessment;
	}

	public boolean isInHealthAssessment() {
		return inHealthAssessment;
	}

	public void setWaitingPeriod(int waitingPeriod) {
		this.waitingPeriod = waitingPeriod;
	}

	public int getWaitingPeriod() {
		return waitingPeriod;
	}
}
