package com.agilex.healthcare.mobilehealthplatform.domain;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.mobilehealthplatform.enumeration.AppointmentRequestStatus;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "appointments-metadata", namespace = Namespace.MobileHealthPlatform)
public class AppointmentsMetadata implements Serializable {
	
	private static final long serialVersionUID = -2148394357927590061L;
	
	public AppointmentsMetadata() {
		
	}
	
	private Map<String, String> availableVistaLocations;

	public Map<String, String> getAvailableVistaLocations() {
		return availableVistaLocations;
	}

	public void setAvailableVistaLocations(
			Map<String, String> availableVistaLocations) {
		this.availableVistaLocations = availableVistaLocations;
	}

	@XmlElement
	private String [] appointmentTypes;
	@XmlElement
	private String [] bestTimetoCallOptions;
	@XmlElement
	private String [] visitTypes;
	@XmlElement
	private String [] purposeOfVisitOptions;
	@XmlElement
	private Integer earliestTimeVeteranCanRequestAppointmentInDays;
	@XmlElement
	private Integer farthestTimeVeteranCanRequestAppointmentInDays;
	@XmlElement
	private Set<DetailCode> detailCodes;
 	
	public String[] getBestTimetoCallOptions() {
		return bestTimetoCallOptions;
	}

	public void setBestTimetoCallOptions(String[] bestTimetoCallOptions) {
		this.bestTimetoCallOptions = bestTimetoCallOptions;
	}

	public String[] getVisitTypes() {
		return visitTypes;
	}

	public void setVisitTypes(String[] visitTypes) {
		this.visitTypes = visitTypes;
	}

	public String[] getPurposeOfVisitOptions() {
		return purposeOfVisitOptions;
	}

	public void setPurposeOfVisitOptions(String[] purposeOfVisitOptions) {
		this.purposeOfVisitOptions = purposeOfVisitOptions;
	}

	public Integer getEarliestTimeVeteranCanRequestAppointmentInDays() {
		return earliestTimeVeteranCanRequestAppointmentInDays;
	}

	public void setEarliestTimeVeteranCanRequestAppointmentInDays(
			Integer earliestTimeVeteranCanRequestAppointmentInDays) {
		this.earliestTimeVeteranCanRequestAppointmentInDays = earliestTimeVeteranCanRequestAppointmentInDays;
	}

	public Integer getFarthestTimeVeteranCanRequestAppointmentInDays() {
		return farthestTimeVeteranCanRequestAppointmentInDays;
	}

	public void setFarthestTimeVeteranCanRequestAppointmentInDays(
			Integer farthestTimeVeteranCanRequestAppointmentInDays) {
		this.farthestTimeVeteranCanRequestAppointmentInDays = farthestTimeVeteranCanRequestAppointmentInDays;
	}

	@XmlElement
	public String[] getAppointmentRequestStatusOptions() {
		String [] statuses = new String[AppointmentRequestStatus.values().length];
		
		int i=0;
		for (AppointmentRequestStatus appStatus : AppointmentRequestStatus.values()) {
			statuses[i++] = appStatus.getName();
		}
		return statuses;
	}

	@XmlElement
	public String[] getAppointmentProcessedAsPerUserNeedOptions() {
		String [] appointmentProcessingOptions = new String[AppointmentProcessedAsPerUserNeed.values().length];
		
		int i=0;
		for (AppointmentProcessedAsPerUserNeed option : AppointmentProcessedAsPerUserNeed.values()) {
			appointmentProcessingOptions[i++] = option.getName();
		}
		return appointmentProcessingOptions;
	}
	
	public String[] getAppointmentTypes() {
		return appointmentTypes;
	}

	public void setAppointmentTypes(String[] appointmentTypes) {
		this.appointmentTypes = appointmentTypes;
	}

	public Set<DetailCode> getDetailCodes() {
		return detailCodes;
	}

	public void setDetailCodes(Set<DetailCode> detailCodes) {
		this.detailCodes = detailCodes;
	}
}
