package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "appointments", namespace = Namespace.MobileHealthPlatform)
public class Appointments extends PatientDataCollection<Appointment> {
	private static final long serialVersionUID = -1232048559610824265L;

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<Appointment> getAppointment() {
		return this;
	}

	public Appointments filterByStatusCodes(String[] statusCodes){
		Appointments filteredAppointments = new Appointments();
		
		if(statusCodes != null && statusCodes.length > 0){
			List<String> statusCodesList = Arrays.asList(statusCodes); 
			
			for (Appointment appointment : this) {
				if(statusCodesList.contains(appointment.getStatusCode())){
					filteredAppointments.add(appointment);
				}
			}
		}else{
			filteredAppointments.addAll(this);
		}
		
		return filteredAppointments;
	}
}
