package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;
import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "appointmentRequests", namespace = Namespace.MobileHealthPlatform)
public class AppointmentRequests extends PatientDataCollection<AppointmentRequest> {
	private static final long serialVersionUID = -1232048559610824265L;

	public Date lastAccessDate;
	
	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<AppointmentRequest> getAppointmentRequest() {
		return this;
	}

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	public Date getLastAccessDate() {
		return lastAccessDate;
	}
	
	public void setLastAccessDate(Date lastAccessDate) {
		this.lastAccessDate = lastAccessDate;
	}
}
