package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "appointmentRequestDetailCode", namespace = Namespace.MobileHealthPlatform)
public class AppointmentRequestDetailCode extends DomainTransferObject implements Comparable<AppointmentRequestDetailCode> {
	private static final long serialVersionUID = -7731727560159684968L;

	@XmlElement
	private String appointmentRequestDetailCodeId;
	
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date createdDate;
	
	@XmlElement
	private DetailCode detailCode;
	
	@XmlElement
	private String userId;
	
	public String getAppointmentRequestDetailCodeId() {
		return appointmentRequestDetailCodeId;
	}

	public void setAppointmentRequestDetailCodeId(String appointmentRequestDetailCodeId) {
		this.appointmentRequestDetailCodeId = appointmentRequestDetailCodeId;
	}
	
	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public DetailCode getDetailCode() {
		return detailCode;
	}

	public void setDetailCode(DetailCode detailCode) {
		this.detailCode = detailCode;
	}

	@Override
	public int compareTo(AppointmentRequestDetailCode that) {
		int result = 0;
		
		if (this.getCreatedDate().before(that.getCreatedDate())) {
			result = 1;
		} else if (this.getCreatedDate().before(that.getCreatedDate())) {
			result = -1;
		}
		
		return result;
	}
}
