package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "appointmentRequest", namespace = Namespace.MobileHealthPlatform)
public class AppointmentRequest extends PatientData implements Dateable, Comparable<AppointmentRequest> {

	private static final long serialVersionUID = -613294957626640127L;

	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date createdDate;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date lastUpdatedDate;

	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date deletedDate;
	
	@XmlTransient
	private boolean activeFlag = true;
	

	@XmlElement
	private String appointmentDate;
	@XmlElement
	private String appointmentTime;
	
	@XmlElement
	private String optionDate1;
	@XmlElement
	private String optionTime1;
	@XmlElement
	private String optionDate2;
	@XmlElement
	private String optionTime2;
	@XmlElement
	private String optionDate3;
	@XmlElement
	private String optionTime3;
	
	@XmlElement
	private String status;
	@XmlElement
	private String appointmentType;
	@XmlElement
	private String visitType;
	@XmlElement
	private Facility facility;
	@XmlElement
	private String email;
	@XmlElement
	private boolean textMessagingAllowed;
	@XmlElement
	private String textMessagingPhoneNumber;
	@XmlElement
	private String phoneNumber;
	
	@XmlElement
	private String purposeOfVisit;
	@XmlElement
	private String otherPurposeOfVisit;
	
	@XmlElement
	private String providerId;
	@XmlElement
	private String providerName;
	@XmlElement
	private String providerPersonClass;
	@XmlElement
	private String providerOption;
	
	@XmlElement
	private boolean secondRequest;

	@XmlElement
	private boolean secondRequestSubmitted;

	@XmlElement
	private AppointmentRequest parentRequest;

	
	@XmlElement
	private Patient patient;
	
	@XmlElement
	private Set<String> bestTimetoCall = new HashSet<String>();
	
	@XmlElement
	private List<AppointmentRequestDetailCode> appointmentRequestDetailCode = new LinkedList<AppointmentRequestDetailCode>();
	
	@XmlElement
	private AppointmentRequestInProcess beingProcessedBy;

	@XmlElement
	private boolean hasVeteranNewMessage;
	
	@XmlElement
	private boolean hasProviderNewMessage;
	
	@XmlElement
	private boolean providerSeenAppointmentRequest;

	public String getAppointmentRequestId() {
		return this.getDataIdentifier().getUniqueId();
	}
	
	public void setAppointmentRequestId(String appointmentRequestId) {
		this.getDataIdentifier().setUniqueId(appointmentRequestId);
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getDeletedDate() {
		return deletedDate;
	}

	public void setDeletedDate(Date deletedDate) {
		this.deletedDate = deletedDate;
	}

	public boolean isActiveFlag() {
		return activeFlag;
	}

	public void setActiveFlag(boolean activeFlag) {
		this.activeFlag = activeFlag;
	}

	public String getOptionDate1() {
		return optionDate1;
	}

	public void setOptionDate1(String optionDate1) {
		this.optionDate1 = optionDate1;
	}

	public String getOptionTime1() {
		return optionTime1;
	}

	public void setOptionTime1(String optionTime1) {
		this.optionTime1 = optionTime1;
	}

	public String getOptionDate2() {
		return optionDate2;
	}

	public void setOptionDate2(String optionDate2) {
		this.optionDate2 = optionDate2;
	}

	public String getOptionTime2() {
		return optionTime2;
	}

	public void setOptionTime2(String optionTime2) {
		this.optionTime2 = optionTime2;
	}

	public String getOptionDate3() {
		return optionDate3;
	}

	public void setOptionDate3(String optionDate3) {
		this.optionDate3 = optionDate3;
	}

	public String getOptionTime3() {
		return optionTime3;
	}

	public void setOptionTime3(String optionTime3) {
		this.optionTime3 = optionTime3;
	}
	
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getAppointmentType() {
		return appointmentType;
	}

	public void setAppointmentType(String appointmentType) {
		this.appointmentType = appointmentType;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getPhoneNumber() {
		return phoneNumber;
	}

	public void setPhoneNumber(String phoneNumber) {
		this.phoneNumber = phoneNumber;
	}

	@Override
	public Date getDate() {
		return createdDate;
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("data identifier: ");
		sb.append(getDataIdentifier().getSystemId());
		sb.append(", ");
		sb.append(getDataIdentifier().getUniqueId());
		sb.append("\n");
		sb.append("patient identifier: ");
		sb.append(getPatientIdentifier().getAssigningAuthority());
		sb.append(", ");
		sb.append(getPatientIdentifier().getUniqueId());
		sb.append("\n");
		
		return sb.toString();
	}

	@Override
	public int compareTo(AppointmentRequest o) {
		int result;
		
		if (this.getCreatedDate() == null || o.getCreatedDate() == null) {
			if (this.getCreatedDate() == null && o.getCreatedDate() == null) {
				result = 0;
			} else if (this.getCreatedDate() == null) {
				result = -1;
			} else {
				result = 1;
			}
		} else {
			result = this.getCreatedDate().compareTo(o.getCreatedDate());
		}
	
		return result;
	}

	public String getVisitType() {
		return visitType;
	}

	public void setVisitType(String visitType) {
		this.visitType = visitType;
	}

	public String getPurposeOfVisit() {
		return purposeOfVisit;
	}

	public void setPurposeOfVisit(String purposeOfVisit) {
		this.purposeOfVisit = purposeOfVisit;
	}

	public Set<String> getBestTimetoCall() {
		return bestTimetoCall;
	}

	public void setBestTimetoCall(Set<String> bestTimetoCall) {
		this.bestTimetoCall = bestTimetoCall;
	}

	public String getOtherPurposeOfVisit() {
		return otherPurposeOfVisit;
	}

	public void setOtherPurposeOfVisit(String otherPurposeOfVisit) {
		this.otherPurposeOfVisit = otherPurposeOfVisit;
	}

	public String getProviderId() {
		return providerId;
	}

	public void setProviderId(String providerId) {
		this.providerId = providerId;
	}

	public String getProviderName() {
		return providerName;
	}

	public void setProviderName(String providerName) {
		this.providerName = providerName;
	}

	public String getProviderPersonClass() {
		return providerPersonClass;
	}

	public void setProviderPersonClass(String providerPersonClass) {
		this.providerPersonClass = providerPersonClass;
	}
	
	public String getProviderOption() {
		return providerOption;
	}

	public void setProviderOption(String providerOption) {
		this.providerOption = providerOption;
	}

	public Date getLastUpdatedDate() {
		return lastUpdatedDate;
	}

	public void setLastUpdatedDate(Date lastUpdatedDate) {
		this.lastUpdatedDate = lastUpdatedDate;
	}

	public boolean isSecondRequest() {
		return secondRequest;
	}

	public void setSecondRequest(boolean secondRequest) {
		this.secondRequest = secondRequest;
	}

	public Patient getPatient() {
		return patient;
	}

	public void setPatient(Patient patient) {
		this.patient = patient;
	}

	@Override
    public String getPatientId() {
		return getPatient().getPatientIdentifier().getUniqueId();
	}

	@Override
	public void setPatientId(String patientId) {
		getPatientIdentifier().setUniqueId(patientId);
		getPatient().getPatientIdentifier().setUniqueId(patientId);
	}

	public List<AppointmentRequestDetailCode> getAppointmentRequestDetailCode() {
		return appointmentRequestDetailCode;
	}

	public void setAppointmentRequestDetailCode(List<AppointmentRequestDetailCode> appointmentRequestDetailCode) {
		this.appointmentRequestDetailCode = appointmentRequestDetailCode;
	}

	public String getAppointmentDate() {
		return appointmentDate;
	}

	public void setAppointmentDate(String appointmentDate) {
		this.appointmentDate = appointmentDate;
	}

	public String getAppointmentTime() {
		return appointmentTime;
	}

	public void setAppointmentTime(String appointmentTime) {
		this.appointmentTime = appointmentTime;
	}

	public Facility getFacility() {
		return facility;
	}

	public void setFacility(Facility facility) {
		this.facility = facility;
	}
	public boolean isSecondRequestSubmitted() {
		return secondRequestSubmitted;
	}

	public void setSecondRequestSubmitted(boolean secondRequestSubmitted) {
		this.secondRequestSubmitted = secondRequestSubmitted;
	}

	public AppointmentRequest getParentRequest() {
		return parentRequest;
	}

	public void setParentRequest(AppointmentRequest parentRequest) {
		this.parentRequest = parentRequest;
	}

	public AppointmentRequestInProcess getBeingProcessedBy() {
		return beingProcessedBy;
	}

	public void setBeingProcessedBy(AppointmentRequestInProcess beingProcessedBy) {
		this.beingProcessedBy = beingProcessedBy;
	}

	public String getTextMessagingPhoneNumber() {
		return textMessagingPhoneNumber;
	}

	public void setTextMessagingPhoneNumber(String textMessagingPhoneNumber) {
		this.textMessagingPhoneNumber = textMessagingPhoneNumber;
	}

	public boolean isTextMessagingAllowed() {
		return textMessagingAllowed;
	}

	public void setTextMessagingAllowed(boolean textMessagingAllowed) {
		this.textMessagingAllowed = textMessagingAllowed;
	}

	public boolean isHasVeteranNewMessage() {
		return hasVeteranNewMessage;
	}

	public void setHasVeteranNewMessage(boolean hasVeteranNewMessage) {
		this.hasVeteranNewMessage = hasVeteranNewMessage;
	}

	public boolean isHasProviderNewMessage() {
		return hasProviderNewMessage;
	}

	public void setHasProviderNewMessage(boolean hasProviderNewMessage) {
		this.hasProviderNewMessage = hasProviderNewMessage;
	}
	
	public boolean isProviderSeenAppointmentRequest() {
		return providerSeenAppointmentRequest;
	}

	public void setProviderSeenAppointmentRequest(
			boolean providerSeenAppointmentRequest) {
		this.providerSeenAppointmentRequest = providerSeenAppointmentRequest;
	}  
	
}
