package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "appointment", namespace = Namespace.MobileHealthPlatform)
public class Appointment extends PatientData implements Dateable {

	private static final long serialVersionUID = -613294957626640127L;

	@XmlElement
	private String providerId;
	@XmlElement
	private String providerName;
	@XmlElement
	private String patientName;
	@XmlElement
	private String patientSSN;
	@XmlElement
	private String clinicVisitId; // Id that points back to the attended appointment
	@XmlElement
	private String clinicId;
	@XmlElement
	private String clinicName;
	@XmlElement
	private String clinicType;
	@XmlElement
	private String facilityName;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date appointmentStartDate;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date appointmentEndDate;
	@XmlElement
	private Integer appointmentDuration;
	@XmlElement
	private String reasonForVisit;
	@XmlElement
	private String status;
	@XmlElement
	private String clinicalNotes;
	@XmlElement
	private Integer alarmOffset; // Minutes
	@XmlElement
	private String repeatFrequency;
	@XmlElement
	private String clinicPhone;
	@XmlElement
	private String statusCode;
	

	public String getStatusCode() {
		return statusCode;
	}

	public void setStatusCode(String statusCode) {
		this.statusCode = statusCode;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Date getAppointmentStartDate() {
		return appointmentStartDate;
	}

	public void setAppointmentStartDate(Date dtStart) {
		this.appointmentStartDate = dtStart;
	}

	public Date getAppointmentEndDate() {
		return appointmentEndDate;
	}

	public void setAppointmentEndDate(Date dtEnd) {
		this.appointmentEndDate = dtEnd;
	}

	public void setProviderName(String providerName) {
		this.providerName = providerName;
	}

	public String getProviderName() {
		return providerName;
	}

	public void setAppointmentDuration(Integer appointmentDuration) {
		this.appointmentDuration = appointmentDuration;
	}

	public Integer getAppointmentDuration() {
		return appointmentDuration;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	public String getPatientName() {
		return patientName;
	}

	public void setClinicName(String clinicName) {
		this.clinicName = clinicName;
	}

	public String getClinicName() {
		return clinicName;
	}

	public void setPatientSSN(String patientSSN) {
		this.patientSSN = patientSSN;
	}

	public String getPatientSSN() {
		return patientSSN;
	}

	public void setReasonForVisit(String reasonForVisit) {
		this.reasonForVisit = reasonForVisit;
	}

	public String getReasonForVisit() {
		return reasonForVisit;
	}

	public void setProviderId(String providerId) {
		this.providerId = providerId;
	}

	public String getProviderId() {
		return providerId;
	}

	public String getClinicType() {
		return clinicType;
	}

	public void setClinicType(String clinicType) {
		this.clinicType = clinicType;
	}

	public String getFacilityName() {
		return facilityName;
	}

	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}

	public String getClinicVisitId() {
		return clinicVisitId;
	}

	public void setClinicVisitId(String clinicVisitId) {
		this.clinicVisitId = clinicVisitId;
	}

	public String getClinicalNotes() {
		return clinicalNotes;
	}

	public void setClinicalNotes(String clinicalNotes) {
		this.clinicalNotes = clinicalNotes;
	}

	public String getClinicId() {
		return clinicId;
	}

	public void setClinicId(String clinicId) {
		this.clinicId = clinicId;
	}

	public Integer getAlarmOffset() {
		return alarmOffset;
	}

	public void setAlarmOffset(Integer alarmOffset) {
		this.alarmOffset = alarmOffset;
	}

	public String getRepeatFrequency() {
		return repeatFrequency;
	}

	public void setRepeatFrequency(String repeatFrequency) {
		this.repeatFrequency = repeatFrequency;
	}

	@Override
	public Date getDate() {
		return this.getAppointmentStartDate();
	}

	public String debugOutput() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("Appointment.providerId: " + providerId);
		buffer.append("\nAppointment.providerName: " + providerName);
		buffer.append("\nAppointment.patientName: " + patientName);
		buffer.append("\nAppointment.patientSSN: " + patientSSN);
		buffer.append("\nAppointment.clinicId: " + clinicId);
		buffer.append("\nAppointment.clinicName: " + clinicName);
		buffer.append("\nAppointment.clinicType: " + clinicType);
		buffer.append("\nAppointment.facilityName: " + facilityName);
		buffer.append("\nAppointment.appointmentStartDate: " + appointmentStartDate);
		buffer.append("\nAppointment.appointmentEndDate: " + appointmentEndDate);
		buffer.append("\nAppointment.appointmentDuration: " + appointmentDuration);
		buffer.append("\nAppointment.reasonForVisit: " + reasonForVisit);
		buffer.append("\nAppointment.status: " + status);
		buffer.append("\nAppointment.clinicalNotes: " + clinicalNotes);
		buffer.append("\nAppointment.alarmOffset " + alarmOffset);
		buffer.append("\nAppointment.repeatFrequency: " + repeatFrequency);
		buffer.append("\nAppointment.clinicPhone: " + clinicPhone);
		buffer.append("\nAppointment.statusCode: " + statusCode);
		
		return buffer.toString();
	}

	public String getClinicPhone() {
		return clinicPhone;
	}

	public void setClinicPhone(String clinicPhone) {
		this.clinicPhone = clinicPhone;
	}


}
