package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "antibiogram", namespace = Namespace.MobileHealthPlatform)
public class AntibiogramURI extends DomainTransferObject {

	private static final long serialVersionUID = 59165794170616382L;

	private static final String antibiogram_facility_organism = "antibiogram-facility-organism";
	private static final String antiobiogram_facility_matrix = "antiobiogram-facility-matrix";
	
	@XmlElement
	private String facilityCode;

	@XmlElement
	private String organismId;
	
	@XmlElement
	public String getUri(){
		if(this.getSelfUri() != null){
			return getSelfUri().toString();
		}else{
			return null;
		}
	}
	
	public String getFacilityCode() {
		return facilityCode;
	}

	public void setFacilityCode(String facilityCode) {
		this.facilityCode = facilityCode;
	}

	public String getOrganismId() {
		return organismId;
	}

	public void setOrganismId(String organismId) {
		this.organismId = organismId;
	}

	@XmlElement
	public String getAntibiogramFacilityOrganismUri() {
		return getUriByTitle(antibiogram_facility_organism);
	}

	@XmlElement
	public String getAntiobiogramFacilityMatrixUri() {
		return getUriByTitle(antiobiogram_facility_matrix);
	}

	private String getUriByTitle(String title){
		AtomLink link = getLink().getLinkByTitle(title);
		if (link != null) {
			return link.getHref().toString();
		} else {
			return null;
		}
	}	
	
}
