package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;
import java.util.Locale;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "allergy", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class Allergy extends PatientData implements Comparable<Allergy>, Dateable {

	private static final long serialVersionUID = 6398358243486259365L;
	
	@XmlAttribute
	private String severity = null;
	@XmlAttribute
	private String reaction = null;
	@XmlAttribute
	private String category = null;
	@XmlAttribute
	private String substance = null;
	@XmlAttribute
	private String note = null;
	@XmlAttribute
	private boolean active = true;
	@XmlAttribute
	private Date onsetDate = null;
	@XmlAttribute
	private Date resolutionDate = null;

	public void setSeverity(String severity) {
		this.severity = severity;
	}

	public String getSeverity() {
		return severity;
	}

	public void setReaction(String reaction) {
		this.reaction = reaction;
	}

	public String getReaction() {
		return reaction;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getCategory() {
		return category;
	}

	public void setSubstance(String substance) {
		this.substance = substance;
	}

	public String getSubstance() {
		return substance;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public String getNote() {
		return note;
	}

	public void setActive(boolean active) {
		this.active = active;
	}

	public boolean isActive() {
		return active;
	}

	public void setOnsetDate(Date onsetDate) {
		this.onsetDate = onsetDate;
	}

	public Date getOnsetDate() {
		return onsetDate;
	}

	public void setResolutionDate(Date resolutionDate) {
		this.resolutionDate = resolutionDate;
	}

	public Date getResolutionDate() {
		return resolutionDate;
	}

	@Override
	public int compareTo(Allergy o) {
		int result;
		
		if (this.getSubstance() == null || o.getSubstance() == null) {
			if (this.getSubstance() == null && o.getSubstance() == null) {
				result = 0;
			} else if (this.getSubstance() == null) {
				result = -1;
			} else {
				result = 1;
			}
		} else {
			result = this.getSubstance().toLowerCase(Locale.ENGLISH).compareTo(o.getSubstance().toLowerCase(Locale.ENGLISH));
		}
	
		return result;
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		
		sb.append(substance);
		sb.append(" ");
		sb.append(reaction);
		sb.append(" ");
		sb.append(getSourceSystem());
		
		return sb.toString();
	}

	@Override
	public Date getDate() {
		return getOnsetDate();
	}
}
