package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlRootElement(name = "admission", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class Admission extends PatientData implements Dateable {

	private static final long serialVersionUID = -2664946105455393004L;

	@XmlAttribute
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date admissionDate = null;
	@XmlAttribute
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date dischargeDate = null;
	@XmlAttribute
	private String facilityName = null;
	@XmlAttribute
	private String admittingProviderName = null;
	@XmlElement
	private String dischargeSummary = null;
    @XmlElement
    private String inpatientSID = null;
    @XmlElement
    private String locationId;
    @XmlElement
    private String locationType;
    @XmlElement
    private String facilityCode;


	public Date getAdmissionDate() {
		return admissionDate;
	}

	public void setAdmissionDate(Date admissionDate) {
		this.admissionDate = admissionDate;
	}

	public Date getDischargeDate() {
		return dischargeDate;
	}

	public void setDischargeDate(Date dischargeDate) {
		this.dischargeDate = dischargeDate;
	}

	public String getFacilityName() {
		return facilityName;
	}

	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}

	public String getDischargeSummary() {
		return dischargeSummary;
	}

	public void setDischargeSummary(String dischargeSummary) {
		this.dischargeSummary = dischargeSummary;
	}

	public String getAdmittingProviderName() {
		return admittingProviderName;
	}

	public void setAdmittingProviderName(String admittingProviderName) {
		this.admittingProviderName = admittingProviderName;
	}

	@Override
	public Date getDate() {
		return getAdmissionDate();
	}

	public String getInpatientSID() {
		return inpatientSID;
	}

	public void setInpatientSID(String inpatientSID) {
		this.inpatientSID = inpatientSID;
	}

	public String getLocationId() {
		return locationId;
	}

	public void setLocationId(String locationId) {
		this.locationId = locationId;
	}

	public String getLocationType() {
		return locationType;
	}

	public void setLocationType(String locationType) {
		this.locationType = locationType;
	}

	public String getFacilityCode() {
		return facilityCode;
	}

	public void setFacilityCode(String facilityCode) {
		this.facilityCode = facilityCode;
	}

}
