package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.ArrayList;
import java.util.Collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "addresses", namespace = Namespace.MobileHealthPlatform)
public class Addresses extends ArrayList<Address>{

	private static final long serialVersionUID = -5363634991268117405L;
	
	public Addresses() {}
	
	public Addresses(Address... addresses) {
		for(Address address : addresses)
			this.add(address);
	}

	@XmlElement(namespace = Namespace.MobileHealthPlatform, name="addresses")
	public Collection<Address> getAddress() {
		return this;
	}
}
