package com.agilex.healthcare.mobilehealthplatform.datalayer.vital;

import java.net.URI;

import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.utils.QueryParameters;

public class VitalsFilterFactory {
	public static VitalEntryFilter createEmptyFilter() {
		VitalEntryFilter filter = new VitalEntryFilter();
		filter.setSection("");

		DateFilter dateFilter = DateFilterFactory.createEmptyFilter();
		setDateFilter(filter, dateFilter);

		return filter;
	}

	public static VitalEntryFilter createFilter(URI u) {
		VitalEntryFilter filter = createEmptyFilter();

		QueryParameters queryParameters = new QueryParameters(u.getQuery());
		filter.setSection(queryParameters.getValue("section"));

		DateFilter dateFilter = DateFilterFactory.createFilterFromUri(u);
		setDateFilter(filter, dateFilter);

		return filter;
	}
	
	public static VitalEntryFilter createFilterFromDate(String startDate, String endDate) {
		VitalEntryFilter filter = createEmptyFilter();

		DateFilter dateFilter = DateFilterFactory.createFilterFromDate(startDate, endDate);
		setDateFilter(filter, dateFilter);
		
		return filter;
	}
	
	public static VitalEntryFilter createFilterFromDateFilter(DateFilter dateFilter) {
		VitalEntryFilter filter = createEmptyFilter();
		setDateFilter(filter, dateFilter);
		
		return filter;
	}
	
	private static void setDateFilter(VitalEntryFilter vitalFilter, DateFilter dateFilter) {
		vitalFilter.setStartDate(dateFilter.getStartDate());
		vitalFilter.setEndDate(dateFilter.getEndDate());
	}
}
