package com.agilex.healthcare.mobilehealthplatform.datalayer.vital;

import java.util.Date;

import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.MutableDateFilter;

public class VitalEntryFilter implements MutableDateFilter {
	private String section = null;
	private Date startDate = null;
	private Date endDate = null;
	private String source = null;
	
	public VitalEntryFilter() {}
	
	public VitalEntryFilter(String section) {
		this.section = section;
	}
	
	public VitalEntryFilter(String section, Date startDate, Date endDate) {
		this.section = section;
		this.startDate = startDate;
		this.endDate = endDate;
	}

	public String getSection() {
		return section;
	}

	public void setSection(String section) {
		this.section = section;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}
	
	@Override
	public String toString() {
		return String.format("[section: %s][source: %s][startDate: %s][endDate: %s]", section, source, startDate, endDate);
	}
}
