package com.agilex.healthcare.mobilehealthplatform.datalayer.vital;

import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.NullSafeStringComparer;

public class VitalDataLayerFilterer {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(VitalDataLayerFilterer.class);

	public static VitalEntries applyFilter(VitalEntries unfilteredVitalEntries, VitalEntryFilter filter) {
        if(filter == null) return unfilteredVitalEntries;

		logger.debug(String.format("begin filter vitals. [vitals.size=%s]", unfilteredVitalEntries.size()));
		VitalEntries filteredVitals = DateFilterer.filterByDate(unfilteredVitalEntries, filter);
		logger.debug(String.format("filter vitals by date. [vitals.size=%s]", filteredVitals.size()));
		filteredVitals = filterBySection(filteredVitals, filter.getSection());
		logger.debug(String.format("filtered vitals by section. [vitals.size=%s]", filteredVitals.size()));
		return filteredVitals;
	}

	private static VitalEntries filterBySection(VitalEntries unfilteredList, String sectionToFilterFor) {
		VitalEntries filteredList;
		if (NullChecker.isNullish(sectionToFilterFor)) {
			filteredList = unfilteredList;
		} else {
			filteredList = new VitalEntries();
			for (VitalEntry possibleMatch : unfilteredList) {
				boolean meetsSectionFilter = isEntryForSection(possibleMatch, sectionToFilterFor);
				if (meetsSectionFilter)
					filteredList.add(possibleMatch);
			}
		}
		return filteredList;
	}

	private static boolean isEntryForSection(VitalEntry possibleMatch, String section) {
		if (NullChecker.isNullish(section))
			return true;
		
		return NullSafeStringComparer.areEqualIgnoreCase(possibleMatch.getSection(), section);
	}
}
