package com.agilex.healthcare.mobilehealthplatform.datalayer.vital;

import java.util.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.*;
import com.agilex.healthcare.utility.NullChecker;

public class ProviderVitalGraphGenerator extends VitalGraphGenerator {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(ProviderVitalGraphGenerator.class);

	public GraphData createGraphDataBySection(VitalEntries vitals, String graphType) {
		logger.debug("Generating vitals graph for provider data");
		Collection<String> observationTypeToGraphArray = new ArrayList<String>();

		if (NullChecker.isNullish(graphType)) {
			throw new IllegalArgumentException("Invalid vital section code " + graphType);
		} else if (graphType.equalsIgnoreCase(VitalSectionCode.Height)) {
			observationTypeToGraphArray.add(ObservationTypeCode.HEIGHT);

		} else if (graphType.equalsIgnoreCase(VitalSectionCode.Weight)) {
			observationTypeToGraphArray.add(ObservationTypeCode.WEIGHT);

		} else if (graphType.equalsIgnoreCase(VitalSectionCode.Mood)) {
			observationTypeToGraphArray.add(ObservationTypeCode.MOOD);

		} else if (graphType.equalsIgnoreCase(VitalSectionCode.Temperature)) {
			observationTypeToGraphArray.add(ObservationTypeCode.BODY_TEMPERATURE);

		} else if (graphType.equalsIgnoreCase(VitalSectionCode.Pain)) {
			observationTypeToGraphArray.add(ObservationTypeCode.PAIN);

		} else if (graphType.equalsIgnoreCase(VitalSectionCode.Respiration)) {
			observationTypeToGraphArray.add(ObservationTypeCode.RESPIRATION);

		} else if (graphType.equalsIgnoreCase(VitalSectionCode.PulseOximetry)) {
			observationTypeToGraphArray.add(ObservationTypeCode.PULSE_OXIMETRY);

		} else if (graphType.equalsIgnoreCase(VitalSectionCode.BloodPressure)) {
			observationTypeToGraphArray.add(ObservationTypeCode.INTRAVASCULAR_DIASTOLIC);
			observationTypeToGraphArray.add(ObservationTypeCode.INTRAVASCULAR_SYSTOLIC);
			
		} else if(graphType.equalsIgnoreCase(VitalSectionCode.Pulse)) {
			observationTypeToGraphArray.add(ObservationTypeCode.HEART_BEAT);

		} else {
			throw new IllegalArgumentException("Invalid vital section code " + graphType);
		}

		return createGraphDataByObservationType(vitals, observationTypeToGraphArray, graphType);
	}
}
