package com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage;

import java.net.URI;

import com.agilex.healthcare.mobilehealthplatform.utils.QueryParameters;
import com.agilex.healthcare.utility.NullChecker;


public class SecureMessageFilter {
	
	public static final String PAGE_NUMBER = "pageNumber";
	public static final String PAGE_SIZE = "pageSize";
	
	private String folder;
	private String pageNumber = "1";
	private String pageSize = "25";
 
	public SecureMessageFilter() 
	{}
	
	public SecureMessageFilter(URI requestUri, String folder) {
		this.folder = folder;
		createFilter(requestUri);
	}
	
	public SecureMessageFilter(String folder) {
		this.folder = folder;
	}
	
	public SecureMessageFilter(String folder, String pageNumber, String pageSize) {
		this.folder = folder;
		this.pageNumber = pageNumber;
		this.pageSize = pageSize;
	}

	public String getFolder() {
		return folder;
	}

	public void setFolder(String folder) {
		validateInteger(pageNumber);
		this.folder = folder;
	}

	public String getPageNumber() {
		return pageNumber;
	}

	public void setPageNumber(String pageNumber) {
		validateInteger(pageNumber);
		this.pageNumber = pageNumber;
	}

	public String getPageSize() {
		return pageSize;
	}

	public void setPageSize(String pageSize) {
		validateInteger(pageSize);
		this.pageSize = pageSize;
	}
	
	private void createFilter(URI requestUri) {
		QueryParameters queryParameters = new QueryParameters(requestUri.getQuery());
		
		setPageSize(queryParameters);
		setPageNumber(queryParameters);
	}

	private void setPageNumber(QueryParameters queryParameters) {
		String pageNumber = queryParameters.getValue(PAGE_NUMBER);
		if(NullChecker.isNotNullish(pageNumber)) {
			setPageNumber(pageNumber);
		}
	}

	private void setPageSize(QueryParameters queryParameters) {
		String pageSize = queryParameters.getValue(PAGE_SIZE);
		if(NullChecker.isNotNullish(pageSize)) {
			setPageSize(pageSize);
		}
	}
	
	private void validateInteger(String field) {
		try {
			Integer.parseInt(field);
		} catch(NumberFormatException nfe) {
			throw new RuntimeException("Page size and Page number must be integer values");
		}
	}
}
