package com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage;

import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageContacts;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageFolders;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageUser;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessages;

public interface SecureMessageDataLayer {

	public SecureMessageUser fetchSecureMessageUser(String userId);
	public SecureMessageFolders fetchFolders(String userId);
	public SecureMessageContacts fetchContacts(String userId);
	
	public SecureMessages fetchSecureMessages(String userId, SecureMessageFilter secureMessageFilter);
	public SecureMessage readSecureMessage(String userId, SecureMessage secureMessage);
	
	public SecureMessage sendSecureMessage(String userId, SecureMessage secureMessage);
	public SecureMessage replySecureMessage(String userId, SecureMessage secureMessage);

	public SecureMessage moveSecureMessage(String userId, String messageId, String folderId);
	
	public SecureMessage saveSecureMessageDraft(String userId, SecureMessage secureMessage);
	public SecureMessage sendSecureMessageDraft(String userId, SecureMessage secureMessage);
	
	void deleteSecureMessageDraft(String userId, String messageId);
}