package com.agilex.healthcare.mobilehealthplatform.datalayer.patientdata;

import java.util.Map;

import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

public class RetrieveRequest {
	private PatientIdentifier patientIdentifier;
	private DataIdentifier dataIdentifier;
	private Map<String, String> options;
	
	public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}

	public PatientIdentifier getPatientIdentifier() {
		return patientIdentifier;
	}

	public String getPatientId() {
		return getPatientIdentifier().getUniqueId();
	}

	public void setDataIdentifier(DataIdentifier dataIdentifier) {
		this.dataIdentifier = dataIdentifier;
	}

	public DataIdentifier getDataIdentifier() {
		return dataIdentifier;
	}

	public String getUniqueId() {
		return getDataIdentifier().getUniqueId();
	}

	public String getOption(String key) {
		return options.get(key);
	}

	public void setOption(String key, String value) {
		options.put(key, value);
	}

}
