package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.utility.NullChecker;

public class PatientSearchCriteria {
	private Patient prototype;
	private String lastInitialPlusLastFourOfSsn;
	private String lastFourOfSsn;
	private String searchString;
	private String vistaSiteCode;

	public void setPrototype(Patient prototype) {
		this.prototype = prototype;
	}

	public Patient getPrototype() {
		return prototype;
	}

	public void setLastInitialPlusLastFourOfSsn(String lastInitialPlusLastFourOfSsn) {
		this.lastInitialPlusLastFourOfSsn = lastInitialPlusLastFourOfSsn;
	}

	public String getLastInitialPlusLastFourOfSsn() {
		return lastInitialPlusLastFourOfSsn;
	}

	public void setLastFourOfSsn(String lastFourOfSsn) {
		this.lastFourOfSsn = lastFourOfSsn;
	}

	public String getLastFourOfSsn() {
		return lastFourOfSsn;
	}

	public void setSearchString(String searchString) {
		this.searchString = searchString;
	}

	public String getSearchString() {
		return searchString;
	}
	
	public String determineSearchString() {
		String searchString = null;

		if (NullChecker.isNotNullish(this.getSearchString()))
			searchString = this.getSearchString();
		else if (this.getPrototype() != null && NullChecker.isNotNullish(this.getPrototype().getLastName())) {
			searchString = this.getPrototype().getLastName();
			if (this.getPrototype() != null && NullChecker.isNotNullish(this.getPrototype().getFirstName()))
				searchString = searchString + "," + this.getPrototype().getFirstName();
		} else if (this.getPrototype() != null && NullChecker.isNotNullish(this.getPrototype().getSsn()))
			searchString = this.getPrototype().getSsn().replace("-", "");
		else if (NullChecker.isNotNullish(this.getLastInitialPlusLastFourOfSsn()))
			searchString = this.getLastInitialPlusLastFourOfSsn();
		else if (NullChecker.isNotNullish(this.getLastFourOfSsn()))
			searchString = this.getLastFourOfSsn();
		
		return searchString;
	}

	public String getVistaSiteCode() {
		return vistaSiteCode;
	}

	public void setVistaSiteCode(String vistaSiteCode) {
		this.vistaSiteCode = vistaSiteCode;
	}

}
