package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

public interface PatientDataLayer {

	public abstract Patients patientSearch(PatientSearchCriteria criteria);

	/**
	 * Please use {@link PatientSupplementalDemographicsDataLayer#fetchDemographics(String)} for Address, Phone, etc.
	 * 
	 * TODO: Need to also create a call for name trait demographics
	 * 
	 * @param id
	 * @return
	 */
	@Deprecated
	public abstract PatientDemographics getDemographics(PatientIdentifier patientIdentifier);

	public abstract Patient getPatient(PatientIdentifier patientIdentifier);

}