package com.agilex.healthcare.mobilehealthplatform.datalayer.paingoals;

import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoal;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoalEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoals;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

public interface PainGoalsDataLayer {
	public PainGoals fetchAllPainGoals(String patientId);
    public PainGoals fetchAllPainGoals(String patientId, DateFilter dateFilter);
	public PainGoals fetchPainGoals(String patientId);
    public PainGoals fetchPainGoals(String patientId, DateFilter dateFilter);
	public PainGoal createNewPainGoal(PainGoal data);
	public PainGoal updatePainGoal(PainGoal data);
	public PainGoalEntries fetchAllPainGoalEntries(String patientId, DataIdentifier dataIdentifier);
	public PainGoalEntry createNewPainGoalEntry(PainGoalEntry data, String goalId);
	public PainGoalEntry updatePainGoalEntry(PainGoalEntry data, String goalId);
	public void deletePainGoalEntry(PainGoalEntry data, String goalId);
	public PainGoal getPainGoal(String patientId, String dataId);
	public void deletePainGoal(PainGoal data);
}
