package com.agilex.healthcare.mobilehealthplatform.datalayer.notification;

import java.util.List;

public interface NotificationCommunicationDataLayer {
	int MAX_NOTIFICATION_LENGTH_IN_BYTES = 160; // JUSTIFICATION: Max length is limited to allow more flexibility in the payload.
	String DEFAULT_SOUND_FILE = "default";

	/**
	 * Sends notification message to a single deviceToken and saves the record.
	 * Return list of invalid tokens.
	 * @param deviceToken
	 * @param message
	 * @return
	 */
	List<String> send(String deviceToken, String message);
	
	/**
	 * Sends notification message to deviceTokens and saves the record.
	 * Return list of invalid tokens.
	 * @param deviceToken
	 * @param message
	 * @return
	 */
	List<String> send(String[] deviceTokens, String message);

	/**
	 * Fetch invalid device tokens from Apple's feedback service.
	 */
	List<String> fetchInvalidDeviceTokens();
}
