package com.agilex.healthcare.mobilehealthplatform.datalayer.medication;

import java.net.URI;
import java.util.Arrays;
import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.utils.QueryParameters;
import com.agilex.healthcare.utility.NullChecker;

public class MedicationFilterFactory {

	private static final String STATUS_QUERYPARAM_KEY = "statuses";
	private static final String RESULTCOUNT_QUERYPARAM_KEY = "resultCount";
	private static final String SOURCE_SYSTEM_QUERYPARAM_KEY = "sourceSystems";
	private static final String MEDICATION_SOURCE_QUERYPARAM_KEY = "medicationSources";
	private static final String PAGE_QUERYPARAM_KEY = "page";

	public static MedicationFilter createEmptyFilter() {
		MedicationFilter filter = new MedicationFilter();
		return filter;
	}
	
	public static MedicationFilter createFilterFromUri(URI uri) {
		QueryParameters queryParams = new QueryParameters(uri.getQuery());
		DateFilter dateFilter = DateFilterFactory.createFilterFromUri(uri);
		MedicationFilter filter = createFilter(queryParams, dateFilter);
		return filter;
	}

	private static MedicationFilter createFilter(QueryParameters queryParams, DateFilter dateFilter) {
		String statuses = queryParams.getValue(STATUS_QUERYPARAM_KEY);
		String resultCount = queryParams.getValue(RESULTCOUNT_QUERYPARAM_KEY);
		String sourceSystem = queryParams.getValue(SOURCE_SYSTEM_QUERYPARAM_KEY);
		String medicationSources = queryParams.getValue(MEDICATION_SOURCE_QUERYPARAM_KEY);
		String page = queryParams.getValue(PAGE_QUERYPARAM_KEY);

		MedicationFilter filter = createEmptyFilter();
		filter.setStatuses(parseCommaSeparatedStrings(statuses));
		filter.setResultCount(valueIfNotNullish(resultCount));
		filter.setSourceSystems(parseCommaSeparatedStrings(sourceSystem));
		filter.setMedicationSources(parseCommaSeparatedStrings(medicationSources));
		filter.setDateFilter(dateFilter);
		filter.setPage(page);
		
		return filter;
	}
	
	public static MedicationFilter createFilterFromDateFilter(DateFilter dateFilter) {
		MedicationFilter filter = createEmptyFilter();
		filter.setDateFilter(dateFilter);
		
		return filter;
	}
	
	private static List<String> parseCommaSeparatedStrings(String values) {
		if (NullChecker.isNotNullish(values)) {
			stripTrailingComma(values);
			String[] splits = values.split(",");
			List<String> parsedValues = Arrays.asList(splits);
			return parsedValues;
		} else {
			return null;
		}
	}

	private static String valueIfNotNullish(String value) {
		if (NullChecker.isNotNullish(value)) {
			return value;
		} else {
			return null;
		}
	}
	
	private static void stripTrailingComma(String value) {
		if(value.charAt(value.length()-1) == ',') {
			value = value.substring(0, value.length()-1);
		}
	}
}
