package com.agilex.healthcare.mobilehealthplatform.datalayer.medication;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.utility.NullChecker;

public class MedicationFilter implements DateFilter {
	public static final String OUTPATIENT = "Outpatient";
	public static final String INPATIENT = "Inpatient";
	
	public static final String STATUS_ACTIVE = "ACTIVE";
	public static final String STATUS_ACTIVESUSPENDED = "ACTIVE/SUSP";
	public static final String STATUS_EXPIRED = "EXPIRED";
	
	private List<String> statuses;
	private DateFilter dateFilter = DateFilterFactory.createEmptyFilter();
	private String resultCount;
	private String page;
	private List<String> sourceSystems;
	private List<String> medicationSources;
	

	public MedicationFilter() {
	}

	public MedicationFilter(List<String> statuses, DateFilter filter, String resultCount, List<String> medicationSources, List<String> sourceSystem) {
		this.statuses = statuses;
		this.dateFilter = DateFilterFactory.createFilterFromDate(filter.getStartDate(), filter.getEndDate());
		this.resultCount = resultCount;
		this.setMedicationSources(medicationSources);
		this.setSourceSystems(sourceSystem);
	}

	public MedicationFilter(List<String> statuses, Date startDate, Date endDate, String resultCount, List<String> medicationSources, List<String> sourceSystem) {
		this.statuses = statuses;
		this.dateFilter = DateFilterFactory.createFilterFromDate(startDate, endDate);
		this.resultCount = resultCount;
		this.setMedicationSources(medicationSources);
		this.setSourceSystems(sourceSystem);
	}

	public DateFilter getDateFilter() {
		return dateFilter;
	}

	public void setDateFilter(DateFilter dateFilter) {
		this.dateFilter = dateFilter;
	}
	
	public String getResultCount() {
		return resultCount;
	}

	public void setResultCount(String resultCount) {
		this.resultCount = resultCount;
	}

	@Override
	public Date getStartDate() {
		return dateFilter.getStartDate();
	}

	@Override
	public Date getEndDate() {
		return dateFilter.getEndDate();
	}

	public List<String> getStatuses() {
		return statuses;
	}

	public void setStatuses(List<String> statuses) {
		this.statuses = statuses;
	}

	public List<String> getSourceSystems() {
		return sourceSystems;
	}

	public void setSourceSystems(List<String> sourceSystems) {
		this.sourceSystems = sourceSystems;
	}

	public List<String> getMedicationSources() {
		return medicationSources;
	}

	public void setMedicationSources(List<String> medicationSources) {
		this.medicationSources = medicationSources;
	}
	
	public String getPage() {
		return page;
	}

	public void setPage(String page) {
		this.page = page;
	}

	public void addActiveStatus(boolean active) {
		if (NullChecker.isNullish(statuses)) {
			statuses = new ArrayList<String>();
		}
		if (active == true) {
			addIfNotAlreadySet(statuses, "Active");
		}
	}

	public void addStatus(String status) {
		if (NullChecker.isNullish(statuses)) {
			statuses = new ArrayList<String>();
		}
		addIfNotAlreadySet(statuses, status);
	}
	
	public void addSourceSystem(String sourceSystem) {
		if (NullChecker.isNullish(sourceSystems)) {
			sourceSystems = new ArrayList<String>();
		}
		addIfNotAlreadySet(sourceSystems, sourceSystem);
	}

	public void addMedicationSources(String medicationSource) {
		if (NullChecker.isNullish(medicationSources)) {
			medicationSources = new ArrayList<String>();
		}
		addIfNotAlreadySet(medicationSources, medicationSource);
	}
	
	private void addIfNotAlreadySet(List<String> criteria, String value) {
		if(criteria.contains(value.toUpperCase()) == false) {
			criteria.add(value.toUpperCase());
		}
	}
}
