package com.agilex.healthcare.mobilehealthplatform.datalayer.medication;

import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

public interface MedicationDataLayer {
	
	public Medications getMedications(PatientIdentifier patientId, MedicationFilter medicationFilter);
	public Medications getMedications(PatientIdentifier patientId, boolean activeOnly);
	
	public Medication getMedicationLite(PatientIdentifier patientId, String orderNumber);
	
	/**
	 * The MDWS lib implementation for this interface is deprecated. MDWS is returning faulty results. 
	 * The data retrieved by this api is a part of the other api defined above.
	 * 
	 * @param patientId
	 * @param orderNumber
	 * @return Medication 
	 */
	public Medication getMedicationDetail(PatientIdentifier patientId, String orderNumber);
}
