package com.agilex.healthcare.mobilehealthplatform.datalayer.learn;

import com.agilex.healthcare.mobilehealthplatform.domain.LearnArticle;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategory;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCondition;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnConditions;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnSubCategory;

public class LearnDataLayerFile implements LearnDataLayer {

	@Override
	public LearnConditions fetchLearnConditions() {
		LearnDataJsonLoader loader = new LearnDataJsonLoader();
		return loader.loadConditions();
	}

	@Override
	public LearnCategories fetchLearnCategories(LearnCondition condition) {
		LearnDataJsonLoader loader = new LearnDataJsonLoader();
		LearnCategories categories = loader.loadCategoriesForCondition(condition.getId());
		return categories;
	}

	@Override
	public LearnCategory fetchLearnCategory(String categoryId) {
		LearnDataJsonLoader loader = new LearnDataJsonLoader();
		LearnCategory category = loader.loadCategory(categoryId);

		for (LearnSubCategory subCategory : category.getSubCategories()) {
			for (LearnArticle articleStub : subCategory.getArticles()) {
				LearnArticle articleWithTitle = loader.loadArticle(articleStub.getId());
				articleStub.setTitle(articleWithTitle.getTitle());
			}
		}
		return category;
	}

	@Override
	public LearnArticle fetchLearnArticle(String articleId) {
		LearnDataJsonLoader loader = new LearnDataJsonLoader();
		return loader.loadArticle(articleId);
	}
}
