package com.agilex.healthcare.mobilehealthplatform.datalayer.learn;

import java.io.IOException;
import java.io.InputStream;

import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

import com.agilex.healthcare.mobilehealthplatform.domain.LearnArticle;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnArticles;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategory;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnConditions;
import com.agilex.healthcare.utility.StreamHelper;

public class LearnDataJsonLoader {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(LearnDataJsonLoader.class);

	public LearnArticle loadArticle(String articleId) {
		LearnArticles articles = loadObjectFromResource("articles.json", LearnArticles.class);
		for (LearnArticle learnArticle : articles) {
			if (learnArticle.getId().equals(articleId)) {
				return learnArticle;
			}
		}
		throw new RuntimeException(String.format("Unable to find article ", articleId));
	}

	public LearnCategory loadCategory(String categoryId) {
		String categoryResourceName = String.format("category.%s.json", categoryId);
		LearnCategory category = loadObjectFromResource(categoryResourceName, LearnCategory.class);

		if (!category.getId().contentEquals(categoryId)) {
			throw new RuntimeException(String.format("Unexpected category ID.  Attempted to load category %s, but category id is %s", categoryId, category.getId()));
		}
		return category;
	}

	public LearnCategories loadCategoriesForCondition(String conditionId) {
		String conditionResourceName = String.format("condition.%s.json", conditionId);
		LearnCategories categories = loadObjectFromResource(conditionResourceName, LearnCategories.class);
		return categories;
	}

	public LearnConditions loadConditions() {
		String conditionsResourceName = "conditions.json";
		return loadObjectFromResource(conditionsResourceName, LearnConditions.class);
	}

	private <T> T loadObjectFromResource(String resourcename, Class<T> valueType) {
		T result = null;
		InputStream resourceStream = null;

		try {
			logger.debug("Loading resource");

			ObjectMapper mapper = new ObjectMapper();
			resourceStream = getAsStream(resourcename);

			if (resourceStream == null)
				throw new RuntimeException("Unable to load resource");

			try {
				result = mapper.readValue(resourceStream, valueType);
			} catch (JsonParseException e) {
				throw new RuntimeException("Unable to parse json into class", e);
			} catch (JsonMappingException e) {
				throw new RuntimeException("Unable to map json into class", e);
			} catch (IOException e) {
				throw new RuntimeException("IO Exception while converting json to class", e);
			}

		} finally {
			StreamHelper.safeClose(resourceStream);
		}

		return result;
	}

	private InputStream getAsStream(String resourceName) {
		InputStream resource = this.getClass().getResourceAsStream(resourceName);
		return resource;
	}

}
