package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import java.util.Locale;

import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;
import com.agilex.healthcare.utility.NullChecker;

public class FacilityFilterer {
	
	public Facilities filter(Facilities facilities, FacilityFilter filter) {
		Facilities filtered;
		
		if (filter == null) {
			filtered = facilities;
		} else {
			String[] tokens = filter.getTerm() == null ? null : filter.getTerm().toLowerCase().split("[ ,]+");
			filtered = new Facilities();
			
			for(Facility facility : facilities) {
				if (!filter.isParentFacilitiesOnly() || facility.getFacilityCode().equals(facility.getParentSiteCode()) ) {
					String stringToSearch = buildString(facility.getName(), facility.getCity(), facility.getState());
					
					boolean match = true;
					if (tokens != null) {
						for (String token : tokens) {
							if (!stringToSearch.contains(token)) {
								match = false;
								break;
							}
						}
					}
					
					if (match && NullChecker.isNotNullish(filter.getParentSiteCodes()) && !filter.getParentSiteCodes().contains(facility.getParentSiteCode())) {
						match = false;
					}
					
					if (match && NullChecker.isNotNullish(filter.getFacilityCodes()) && !filter.getFacilityCodes().contains(facility.getFacilityCode())) {
						match = false;
					}
					
					if (match && NullChecker.isNotNullish(filter.getFacilityName()) && !filter.getFacilityName().toLowerCase(Locale.ENGLISH).equals(facility.getName().toLowerCase(Locale.ENGLISH))) {
						match = false;
					}
					
					if (match) {
						filtered.add(facility);
					}
				}
			}
		}
		
		return filtered;
	}
	
	private String buildString(String...args) {
		StringBuilder sb = new StringBuilder();
		
		if (args != null) {
			for (String arg : args) {
				if (NullChecker.isNotNullish(arg)) {
					sb.append(arg.toLowerCase());
					sb.append(" ");
				}
			}
		}
		
		return sb.toString();
	}
}
