package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.utils.QueryParameters;
import com.agilex.healthcare.utility.NullChecker;

public class FacilityFilterFactory {
	private List<String> pilotSiteCodes;
	
	public FacilityFilterFactory(List<String> pilotSiteCodes) {
		if (NullChecker.isNotNullish(pilotSiteCodes)) {
			this.pilotSiteCodes = new LinkedList<String>(pilotSiteCodes);
		} else {
			this.pilotSiteCodes = new LinkedList<String>();
		}
	}
	
	public FacilityFilter createEmptyFacilityFilter() {
		FacilityFilter facilityFilter = new FacilityFilter();
		addParentSiteCodes(facilityFilter);
		
		return facilityFilter;
	}
	
	public FacilityFilter createFromUri(URI u) {
		FacilityFilter facilityFilter = createEmptyFacilityFilter();
		
		QueryParameters queryParameters = new QueryParameters(u.getQuery());
		facilityFilter.setTerm(queryParameters.getValue("term"));
		facilityFilter.setParentFacilitiesOnly(queryParameters.getValueAsBoolean("parentFacilitiesOnly"));
		
		return facilityFilter;
	}
	
	public FacilityFilter createFromTerm(String term) {
		FacilityFilter facilityFilter = createEmptyFacilityFilter();
		
		if (NullChecker.isNotNullish(term)) {
			facilityFilter.setTerm(term);
		}
		
		return facilityFilter;
	}
	
	public FacilityFilter createFromFacilityCode(String facilityCode) {
		FacilityFilter facilityFilter = createEmptyFacilityFilter();
		
		if (NullChecker.isNotNullish(facilityCode)) {
			facilityFilter.addFacilityCode(facilityCode);
		}
		
		return facilityFilter;
	}
	
	public FacilityFilter createFromFacilityCodes(List<String> facilityCodes) {
		FacilityFilter facilityFilter = createEmptyFacilityFilter();
		
		if (NullChecker.isNotNullish(facilityCodes)) {
			facilityFilter.setFacilityCode(facilityCodes);
		}
		
		return facilityFilter;
	}
	
	private void addParentSiteCodes(FacilityFilter filter) {
		filter.setParentSiteCode(pilotSiteCodes);
	}
}
