package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

import com.agilex.healthcare.utility.NullChecker;

public class FacilityFilter implements Serializable {

	private static final long serialVersionUID = -6205640205800235431L;
	
	private List<String> facilityCodes = new LinkedList<String>();
	private List<String> parentSiteCodes = new LinkedList<String>();
	private String term;
	private String facilityName;
	private boolean parentFacilitiesOnly;

	public String getTerm() {
		return term;
	}

	public void setTerm(String term) {
		this.term = term;
	}

	public List<String> getFacilityCodes() {
		return facilityCodes;
	}

	public void setFacilityCode(List<String> facilityCodes) {
		this.facilityCodes = new LinkedList<String>(facilityCodes);
	}
	
	public void addFacilityCode(String facilityCode) {
		this.facilityCodes.add(facilityCode);
	}
	
	public void removeFacilityCode(String facilityCode) {
		this.facilityCodes.remove(facilityCode);
	}

	public List<String> getParentSiteCodes() {
		return parentSiteCodes;
	}

	public void setParentSiteCode(List<String> parentSiteCodes) {
		this.parentSiteCodes = new LinkedList<String>(parentSiteCodes);
	}
	
	public void addParentSiteCode(String parentSiteCode) {
		this.parentSiteCodes.add(parentSiteCode);
	}
	
	public void removeParentSiteCode(String parentSiteCode) {
		this.parentSiteCodes.remove(parentSiteCode);
	}

	public boolean isParentFacilitiesOnly() {
		return parentFacilitiesOnly;
	}

	public void setParentFacilitiesOnly(boolean parentFacilitiesOnly) {
		this.parentFacilitiesOnly = parentFacilitiesOnly;
	}

	public String getFacilityName() {
		return facilityName;
	}

	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}
	
	public Integer getKeyForCache() {
		int code = 0;
		if (facilityName != null)
			code ^= facilityName.hashCode();
		
		if (term != null)
			code ^= term.hashCode();
		
		code ^= parentFacilitiesOnly ? 41 : 37;
		
		if (NullChecker.isNullish(parentSiteCodes)) {
			code ^= 23;
		} else {
			for (String str : parentSiteCodes) {
				code ^= str.hashCode();
			}
		}
		
		if (NullChecker.isNullish(facilityCodes)) {
			code ^= 117;
		} else {
			for (String str : facilityCodes) {
				code ^= str.hashCode();
			}
		}
		
		return new Integer(code);
	}
}
