package com.agilex.healthcare.mobilehealthplatform.datalayer.document;

import com.agilex.healthcare.mobilehealthplatform.domain.Document;
import com.agilex.healthcare.mobilehealthplatform.domain.Documents;
import com.agilex.healthcare.mobilehealthplatform.domain.RelatedDataItem;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.NullSafeStringComparer;

public class DocumentFilterer {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(DocumentFilterer.class);

	public static Documents filter(Documents documents, DocumentFilter filter) {
		boolean meetsFilter = false;
		boolean meetsTitle = false;

		Documents filteredDocuments = new Documents();
		if (NullChecker.isNullish(documents)) {
			return documents;
		}

		if (filter == null) {
			return documents;
		}

		for (Document document : documents) {
			meetsFilter = DocumentFilterer.validateParentItem(filter.getParentItem(), document.getParentData());
			meetsTitle = DocumentFilterer.validateStringsEqual(filter.getDocumentTitle(), document.getDocumentTitle());

			if (meetsFilter && meetsTitle) {
				filteredDocuments.add(document);
			}
		}

		return filteredDocuments;
	}

	public static boolean validateStringsEqual(String filterConstraint, String valueToValidate) {
		if (NullChecker.isNullish(filterConstraint)) {
			return true;
		} else {
//			logger.debug(String.format("::: in filter, comparing string values [%s]==[%s]", filterConstraint, valueToValidate));
			return NullSafeStringComparer.areEqual(filterConstraint, valueToValidate);
		}
	}

	public static boolean validateParentItem(RelatedDataItem filterParentData, RelatedDataItem documentParentData) {
//		logger.debug(String.format("::: in filter, validating parent item's equal [filter parent data: %s][document parent data %s]", filterParentData, documentParentData));

		if (filterParentData == null)
			return true;
		if (documentParentData == null)
			return false;

		boolean meetsDomain = validateStringsEqual(filterParentData.getDomain(), documentParentData.getDomain());
		boolean meetsUniqueId = validateStringsEqual(filterParentData.getUniqueId(), documentParentData.getUniqueId());
		boolean meetsCommunityId = validateStringsEqual(filterParentData.getCommunityId(), documentParentData.getCommunityId());

		return meetsDomain && meetsUniqueId && meetsCommunityId;

	}

	public static boolean documentAndFilterCanBeCompared(RelatedDataItem filteredParentData, RelatedDataItem documentParentData) {
		return filteredParentData != null && documentParentData != null;
	}
}
