package com.agilex.healthcare.mobilehealthplatform.datalayer.document;

import java.net.URI;

import com.agilex.healthcare.mobilehealthplatform.domain.RelatedDataItem;
import com.agilex.healthcare.mobilehealthplatform.utils.QueryParameters;
import com.agilex.healthcare.utility.NullChecker;

public class DocumentFilterFactory {
	
	private static final String DOMAIN_QUERYPARAM_KEY = "domain";
	private static final String UNIQUEID_QUERY_PARAM_KEY = "uniqueId";
	private static final String COMMUNITYID_QUERY_PARAM_KEY = "communityId";
	private static final String TITLE_QUERYPARAM_KEY = "title";

	public static DocumentFilter createFilterFromUri(URI uri) {
		QueryParameters queryParams = new QueryParameters(uri.getQuery());
		DocumentFilter filter = createFilter(queryParams);
		return filter;
	}

	private static DocumentFilter createFilter(QueryParameters queryParams) {
		String domain = queryParams.getValue(DOMAIN_QUERYPARAM_KEY);
		String uniqueId = queryParams.getValue(UNIQUEID_QUERY_PARAM_KEY);
		String communityId = queryParams.getValue(COMMUNITYID_QUERY_PARAM_KEY);
		String title = queryParams.getValue(TITLE_QUERYPARAM_KEY);
		
		DocumentFilter filter = new DocumentFilter();
		RelatedDataItem relatedDataItem = new RelatedDataItem();
		
		if(NullChecker.isNotNullish(domain)) {
			relatedDataItem.setDomain(domain);
		}
		if(NullChecker.isNotNullish(uniqueId)) {
			relatedDataItem.setUniqueId(uniqueId);
		}
		if(NullChecker.isNotNullish(communityId)) {
			relatedDataItem.setCommunityId(communityId);
		}
		if(NullChecker.isNotNullish(title)) {
			filter.setDocumentTitle(title);
		}
		
		filter.setParentItem(relatedDataItem);
		
		return filter;
	}

}
