package com.agilex.healthcare.mobilehealthplatform.datalayer.dailyevents;

import java.util.Date;

import com.agilex.healthcare.mobilehealthplatform.domain.DailyEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.DailyEvents;

public class DailyEventDataLayerFilterer {

	public static DailyEvents applyFilter(DailyEvents unfilteredDailyEventsForPatient, DailyEventDataLayerFilter filter) {
		DailyEvents filteredDailyEvents = new DailyEvents();
		for (DailyEvent possibleMatch : unfilteredDailyEventsForPatient) {
			boolean meetsDateFilter = isBetweenDates(possibleMatch, filter.getStartDate(), filter.getEndDate());
			if (meetsDateFilter)
				filteredDailyEvents.add(possibleMatch);
		}
		return filteredDailyEvents;
	}

	private static boolean isBetweenDates(DailyEvent possibleMatch, Date startDate, Date endDate) {
		boolean meetsFilter = true;
		if (startDate != null && startDate.compareTo(possibleMatch.getEntryDate()) > 0)
			meetsFilter = false;
		if (endDate != null && endDate.compareTo(possibleMatch.getEntryDate()) < 0)
			meetsFilter = false;
		return meetsFilter;
	}
}
