package com.agilex.healthcare.mobilehealthplatform.datalayer.audit;

import com.agilex.healthcare.mobilehealthplatform.domain.AuditLog;
import com.agilex.healthcare.mobilehealthplatform.domain.AuditLogs;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;
import com.agilex.healthcare.utility.NullChecker;

public class AuditLogFilterer {

	public static AuditLogs filter(AuditLogs auditLogs, AuditLogFilter filter) {
		if (NullChecker.isNullish(auditLogs)) {
			return new AuditLogs();
		}

		if (filter == null) {
			return auditLogs;
		}

		AuditLogs filteredAuditLogs = new AuditLogs();
		filteredAuditLogs = filterByDate(auditLogs, filter);
		filteredAuditLogs = filterByType(filteredAuditLogs, filter);
		filteredAuditLogs = filterBySubType(filteredAuditLogs, filter);
		return filteredAuditLogs;
	}

	private static AuditLogs filterByDate(AuditLogs auditLogs, AuditLogFilter auditLogFilter) {
		return DateFilterer.filterByDate(auditLogs, auditLogFilter.getDateFilter());
	}

	private static AuditLogs filterByType(AuditLogs filteredAuditLogs, AuditLogFilter filter) {
		AuditLogs returnedAuditLogs = new AuditLogs();
		if (filter.getType() != null) {
			for (AuditLog auditLog : filteredAuditLogs) {
				if (auditLog.getType().equals(filter.getType())) {
					returnedAuditLogs.add(auditLog);
				}
			}
		} else {
			returnedAuditLogs = filteredAuditLogs;
		}
		return returnedAuditLogs;
	}

	private static AuditLogs filterBySubType(AuditLogs filteredAuditLogs, AuditLogFilter filter) {
		AuditLogs returnedAuditLogs = new AuditLogs();
		if (filter.getSubType() != null) {
			for (AuditLog auditLog : filteredAuditLogs) {
				if (auditLog.getSubType().equals(filter.getSubType())) {
					returnedAuditLogs.add(auditLog);
				}
			}
		} else {
			returnedAuditLogs = filteredAuditLogs;
		}
		return returnedAuditLogs;
	}

}
