package com.agilex.healthcare.mobilehealthplatform.datalayer.audit;

import java.util.Date;

import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;

public class AuditLogFilter implements DateFilter {
	private DateFilter dateFilter = DateFilterFactory.createEmptyFilter();
	private String type;
	private String subType;
	
	public AuditLogFilter() {}
	
	public AuditLogFilter(DateFilter filter) {
		dateFilter = DateFilterFactory.createFilterFromDate(filter.getStartDate(), filter.getEndDate());
	}
		
	@Override
	public Date getStartDate() {
		return dateFilter.getStartDate();
	}

	@Override
	public Date getEndDate() {
		return dateFilter.getEndDate();
	}

	public DateFilter getDateFilter() {
		return this.dateFilter;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getSubType() {
		return subType;
	}

	public void setSubType(String subType) {
		this.subType = subType;
	}
}

