package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResults;
import com.agilex.healthcare.mobilehealthplatform.domain.GraphData;
import com.agilex.healthcare.mobilehealthplatform.domain.GraphDataSeries;
import com.agilex.healthcare.mobilehealthplatform.domain.GraphItem;
import com.agilex.healthcare.utility.DateHelper;

public class AssessmentResultGraphGenerator {

	public GraphData createGraphData(AssessmentResults assessmentResults) {
		GraphData graphData = new GraphData();

		GraphDataSeries dataSeries = new GraphDataSeries();
		dataSeries.setTitle("Assessment Result Scores");

		for (AssessmentResult assessmentResult : assessmentResults) {
			GraphItem item = buildGraphItem(assessmentResult);
			dataSeries.add(item);
			updateMinMax(dataSeries, item);
		}
		graphData.getDataSeriesCollection().add(dataSeries);

		graphData.setGraphTitle("Assessment Result Score over Time");

		return graphData;
	}

	private GraphItem buildGraphItem(AssessmentResult assessmentResult) {
		GraphItem item = new GraphItem();
		item.setX(DateHelper.dateToSeconds(assessmentResult.getDateTaken()));
		item.setY(assessmentResult.getScore());

		item.setDate(assessmentResult.getDateTaken());
		item.setLabel(buildLabel(assessmentResult));

		return item;
	}

	private String buildLabel(AssessmentResult assessmentResult) {
		return Integer.toString(assessmentResult.getScore());
	}

	private void updateMinMax(GraphDataSeries dataSeries, GraphItem item) {
		dataSeries.setMaxX(Math.max(dataSeries.getMaxX(), item.getX()));
		dataSeries.setMaxY(Math.max(dataSeries.getMaxY(), item.getY()));
		if (dataSeries.size() == 1) {
			dataSeries.setMinX(item.getX());
			dataSeries.setMinY(item.getY());
		} else {
			dataSeries.setMinX(Math.min(dataSeries.getMinX(), item.getX()));
			dataSeries.setMinY(Math.min(dataSeries.getMinY(), item.getY()));
		}
	}

}
