package com.agilex.healthcare.mobilehealthplatform.datalayer.assessment;

import com.agilex.healthcare.mobilehealthplatform.domain.Assessment;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentQuestion;
import com.agilex.healthcare.mobilehealthplatform.domain.Assessments;

public class AssessmentDataLayerFile implements AssessmentDataLayer {
	private AssessmentDataJsonLoader loader = new AssessmentDataJsonLoader();

	@Override
	public Assessments fetchActiveAssessments() {
		return loader.loadActiveAssessments();
	}

	@Override
	public Assessment fetchAssessment(String assessmentId) {
		Assessment assessment = loader.loadAssessment(assessmentId);
		return assessment;
	}

	@Override
	public AssessmentQuestion fetchQuestion(String assessmentId, String questionId) {
		Assessment assessment = fetchAssessment(assessmentId);
		return assessment.getQuestionById(questionId);
	}

	@Override
	public Assessments fetchAssessmentsForHealthAssessment() {
		Assessments activeAssessments = fetchActiveAssessments();
		Assessments healthAssessmentAssessments = new Assessments();
		for (Assessment activeAssessment : activeAssessments) {
			Assessment loadedActiveAssessment = fetchAssessment(activeAssessment.getId());
			if (loadedActiveAssessment.isInHealthAssessment()) {
				Assessment liteVersionOfAssessment = new Assessment();
				liteVersionOfAssessment.setId(loadedActiveAssessment.getId());
				liteVersionOfAssessment.setUniqueTitle(loadedActiveAssessment.getUniqueTitle());
				healthAssessmentAssessments.add(liteVersionOfAssessment);
			}
		}
		return healthAssessmentAssessments;
	}

    @Override
    public Assessment saveAssessment(Assessment assessment) {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public void deleteAssessment(Assessment assessment) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

}
