package com.agilex.healthcare.mobilehealthplatform.datalayer.assessment;

import java.io.IOException;
import java.io.InputStream;

import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

import com.agilex.healthcare.mobilehealthplatform.domain.Assessment;
import com.agilex.healthcare.mobilehealthplatform.domain.Assessments;
import com.agilex.healthcare.utility.StreamHelper;

public class AssessmentDataJsonLoader {

	public Assessments loadActiveAssessments() {
		String assessmentsResourceName = "published_assessments.json";
		return loadObjectFromResource(assessmentsResourceName, Assessments.class);
	}

	public Assessment loadAssessment(String assessmentId) {
		String assessmentResourceName = String.format("assessment.%s.json", assessmentId);
		Assessment assessment = loadObjectFromResource(assessmentResourceName, Assessment.class);

		checkAssessmentIdMatchesRequestId(assessmentId, assessment);
		return assessment;
	}

	private void checkAssessmentIdMatchesRequestId(String assessmentId, Assessment assessment) {
		if (!assessment.getId().contentEquals(assessmentId)) {
			throw new RuntimeException(String.format("Unexpected assessment ID.  Attempted to load assessment %s, but assessment id is %s", assessmentId, assessment.getId()));
		}
	}

	private <T> T loadObjectFromResource(String resourcename, Class<T> valueType) {
		T result;
		InputStream resourceStream = null;

		try {
			ObjectMapper mapper = new ObjectMapper();
			resourceStream = this.getClass().getResourceAsStream(resourcename);

			if (resourceStream == null)
				throw new RuntimeException("Unable to load resource");

			try {
				result = mapper.readValue(resourceStream, valueType);
			} catch (JsonParseException e) {
				throw new RuntimeException("Unable to parse json into class", e);
			} catch (JsonMappingException e) {
				throw new RuntimeException("Unable to map json into class", e);
			} catch (IOException e) {
				throw new RuntimeException("IO Exception while converting json to class", e);
			}
		} finally {
			StreamHelper.safeClose(resourceStream);
		}
		return result;
	}
}