package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import java.util.Date;

import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

public class AppointmentRequestFilter implements DateFilter {
	private String facilityName;
	private String parentSiteCode;
	private Date startDate;
	private Date endDate;

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("Facility Name: ");
		sb.append(facilityName);
		sb.append("\n");
		sb.append("Parent Site Code: ");
		sb.append(parentSiteCode);
		sb.append("\n");
		sb.append("Start Date: ");
		sb.append(startDate);
		sb.append("\n");
		sb.append("End Date: ");
		sb.append(endDate);
		sb.append("\n");
		
		return sb.toString();
	}

	@Override
	public Date getStartDate() {
		return startDate;
	}

	@Override
	public Date getEndDate() {
		return endDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getParentSiteCode() {
		return parentSiteCode;
	}

	public void setParentSiteCode(String parentSiteCode) {
		this.parentSiteCode = parentSiteCode;
	}

	public String getFacilityName() {
		return facilityName;
	}

	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}
}
