package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequest;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestMessages;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequests;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

public interface AppointmentRequestDataLayer {

	AppointmentRequests fetchAppointmentRequestsByPatient(String patientId, DateFilter filter);
	AppointmentRequests fetchAppointmentRequests(AppointmentRequestFilter filter);

	AppointmentRequest fetchAppointmentRequest(String patientId, String appointmentRequestId);

	AppointmentRequest saveAppointmentRequest(AppointmentRequest appointmentRequest);

	void deleteAppointmentRequest(AppointmentRequest appointmentRequest);

    AppointmentRequestMessages fetchAppointmentRequestMessages(String patientId, String appointRequestId);

    AppointmentRequestMessage saveAppointmentRequestMessage(String patientId, AppointmentRequestMessage appointmentRequestMessage, boolean isProvider);
    
    AppointmentRequest updateMessageFlag(String patientId, String appointmentRequestId, boolean isProvider);
        
    AppointmentRequest markAppointmentRequestIsSeenByProvider(String patientId, String appointmentRequestId);
}
