package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

public interface AppointmentDataLayer {

	public Appointments getProviderAppointments(String providerId, DateFilter filter);

	public Appointments getClinicAppointments(String clinicId, DateFilter filter);

	public Appointments fetchAppointmentsByPatient(PatientIdentifier patientIdentifier, DateFilter filter);
	
	/**
	 * @deprecated  @shouldIncludeDetails parameter is ignored. Notes are now requested separately via ClinicalNoteDataLayer. 
	 * This overload method is no longer needed.
	 */
	@Deprecated
	public Appointments fetchAppointmentsByPatient(PatientIdentifier patientIdentifier, DateFilter filter, boolean shouldIncludeDetails);

	public Appointment fetchAppointment(PatientIdentifier patientIdentifier, String appointmentId);

}
