package com.agilex.healthcare.mobilehealthplatform.datalayer.antibiogram;

import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.antibiogram.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

public interface AntibiogramDataLayer {
	public Organisms fetchOrganisms(String facilitySiteCode);
	public OrganismGroups fetchOrganismGroups(String facilitySiteCode);
	public AntibiogramSummaries fetchSummaries(String facilitySiteCode, List<String> organismIds, DateFilter dateFilter);
	public List<String> fetchOrganismsByGroup(String facilitySiteCode, String groupId);
	public AntibiogramMatrix fetchMatrix(String facilitySiteCode, DateFilter dateFilter);
}
