package com.agilex.healthcare.mobilehealthplatform.datalayer;

import java.io.Serializable;
import java.util.Properties;

import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.type.Type;

public class StringIdentifierGenerator implements PersistentIdentifierGenerator, Configurable {
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(StringIdentifierGenerator.class);
	private final SequenceGenerator delegate = new SequenceGenerator();
	
	
	public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
		String generatedValue = String.valueOf(delegate.generate(session, object));
		//LOGGER.debug(generatedValue);
		return generatedValue;
	}

	@Override
	public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
		delegate.configure(type, params, dialect);
	}

	@Override
	public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
		return delegate.sqlCreateStrings(dialect);
	}

	@Override
	public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
		return delegate.sqlDropStrings(dialect);
	}

	@Override
	public Object generatorKey() {
		return delegate.generatorKey();
	}
}
