package com.agilex.healthcare.mobilehealthplatform.client.datalayer;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.NotImplementedException;

import com.agilex.healthcare.mobilehealthplatform.client.MobileHealthClient;
import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.LabDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.datalayer.problem.ProblemDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroups;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.ResourceUriEncoder;

public class PatientsResourceClient implements PatientDataLayer, AllergyDataLayer, ProblemDataLayer, LabDataLayer, MedicationDataLayer, AppointmentDataLayer {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(PatientsResourceClient.class);

	private MobileHealthClient mhpClient;

	public PatientsResourceClient(MobileHealthClient mhpClient) {
		this.mhpClient = mhpClient;
	}

	@Override
	public Patients patientSearch(PatientSearchCriteria criteria) {
		return this.mhpClient.patientsResource().queryParam("searchstring", criteria.getSearchString()).get(Patients.class);
	}

	@Override
	public PatientDemographics getDemographics(PatientIdentifier patientIdentifier) {
		Patient patient = getPatient(patientIdentifier);
		URI uri = patient.getDemographicsUri();
		return this.mhpClient.resource(uri).get(PatientDemographics.class);
	}

	@Override
	public Patient getPatient(PatientIdentifier patientIdentifier) {
		Patients patients = this.mhpClient.patientsResource().queryParam("patientid", patientIdentifier.getUniqueId()).get(Patients.class);
		Patient patient = null;
		if (NullChecker.isNotNullish(patients))
			patient = patients.get(0);
		return patient;
	}

	public Allergies getPatientAllergies(String patientId) {
		throw new NotImplementedException();
		
	}

	@Override
	public Appointments getProviderAppointments(String clinicId, DateFilter dateFilter) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Appointments getClinicAppointments(String clinicId, DateFilter dateFilter) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Medications getMedications(PatientIdentifier patientId, boolean activeOnly) {
		return getPatientDataList(patientId, LinkTitles.PatientMedications, Medications.class, Medication.class);
	}

	@Override
	public Medication getMedicationLite(PatientIdentifier patientId, String orderNumber) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Medication getMedicationDetail(PatientIdentifier patientId, String orderNumber) {
		throw new UnsupportedOperationException();
	}

	@Override
	public LabResults getLabResults(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		//String patientId = patientIdentifier.getUniqueId();
		return getPatientDataList(patientIdentifier, LinkTitles.PatientChemistryLabResults, LabResults.class, LabResult.class);
	}

	@Override
	public LabTestGroups lookupLabGroupsByTestId(String labTestId) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Map<String, LabTestGroups> lookupLabGroupsByTestIds(List<String> labTestIds) {
		throw new UnsupportedOperationException();
	}

	@Override
	public LabResults getLabResultsByTestId(PatientIdentifier patientIdentifier, String testId) {
		throw new UnsupportedOperationException();
	}

	private <Tl extends Collection<Td>, Td extends PatientData> Tl getPatientDataList(PatientIdentifier patientId, String uriTitle, Class<Tl> listClass, Class<Td> dataClass) {
		logger.debug(String.format("get patient id to determine uri for [%s]", uriTitle));
		Patient patient = getPatient(patientId);
		logger.debug("retrieved patient");
		URI uri = patient.getLink().getUriByTitle(uriTitle);
		logger.debug(String.format("retrieve data [%s] by uri", uriTitle));
		Tl dataList = this.mhpClient.resource(uri).get(listClass);
		logger.debug(String.format("retrieved data [%s] by uri [%s] => [%s]", uriTitle, uri.toString(), dataList));

		updateUniqueIdToSelfUri((Collection<Td>) dataList);
		logger.debug("set unique id's to encoded uri");

		return dataList;
	}

	// private <Td> Td getPatientData(String dataId, Class<Td> dataClass) {
	// logger.debug(String.format("decoding data id [%s] to get data uri",
	// dataId));
	// String decodedDataId = ResourceUriEncoder.decodeUri(dataId);
	// logger.debug(String.format("decoded data id [%s]->[%s]", dataId,
	// decodedDataId));
	// URI uri = UriBuilder.fromPath(decodedDataId).build();
	// logger.debug(String.format("retrieve data by uri [%s]", uri.toString()));
	// Td data = this.mhpClient.resource(uri).get(dataClass);
	// logger.debug(String.format("retrieved data [%s]", data));
	// return data;
	// }

	private <Td extends PatientData> void updateUniqueIdToSelfUri(Collection<Td> dataList) {
		for (Object data : dataList) {
			if (data instanceof PatientData) {
				PatientData patientData = (PatientData) data;
				String patientDataSelfUri = patientData.getSelfUri().toString();
				if (NullChecker.isNotNullish(patientDataSelfUri)) {
					String encodedUri = ResourceUriEncoder.encodeUri(patientDataSelfUri);
					patientData.getDataIdentifier().setUniqueId(encodedUri);
				}
			}
		}
	}

    @Override
    public Appointments fetchAppointmentsByPatient(PatientIdentifier patientIdentifier, DateFilter filter) {
        throw new NotImplementedException();
    }

    @Override
    public Appointments fetchAppointmentsByPatient(PatientIdentifier patientIdentifier, DateFilter filter, boolean shouldIncludeDetails) {
        throw new NotImplementedException();
    }

    @Override
    public Appointment fetchAppointment(PatientIdentifier patientIdentifier, String appointmentId) {
        throw new NotImplementedException();
    }

    @Override
	public LabResults getLabResultsLite(String patientId, DateFilter dateFilter) {
		throw new NotImplementedException();
	}

	@Override
	public Medications getMedications(PatientIdentifier patientId, MedicationFilter medicationFilter) {
		throw new NotImplementedException();
	}


	public Allergies fetchAllergies(String patientId, DateFilter filter) {
		throw new NotImplementedException();
	}

	@Override
	public Allergies fetchAllergies(PatientIdentifier patientIdentifier, DateFilter filter) {
		return getPatientDataList(patientIdentifier, LinkTitles.PatientAllergies, Allergies.class, Allergy.class);
	}

	@Override
	public Problems fetchProblems(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		throw new NotImplementedException();
	}
	
}
