package com.agilex.healthcare.mobilehealthplatform.client;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.sun.jersey.api.client.*;
import com.sun.jersey.api.client.filter.*;

public class MobileHealthClient extends Client {
	private URI mhpUri;
	private AuthenticationInfo authenticationInfo;

	public MobileHealthClient(URI uri, AuthenticationInfo authenticationInfo) {
		this.mhpUri = uri;
		this.authenticationInfo = authenticationInfo;
		initializeSecurity();
	}

	public MobileHealthClient(String uri, AuthenticationInfo authenticationInfo) {
		this.mhpUri = UriBuilder.fromPath(uri).build();
		this.authenticationInfo = authenticationInfo;
		initializeSecurity();
	}

	private void initializeSecurity() {
		if (this.authenticationInfo != null) {
			ClientFilter authFilter = null;
			String username = authenticationInfo.getUsername();
			String password = authenticationInfo.getPassword();

			if (authenticationInfo.getAuthtype().toUpperCase().contentEquals(AuthenticationInfo.BASIC_AUTHENTICATION)) {
				authFilter = new HTTPBasicAuthFilter(username, password);
			}
			if (authenticationInfo.getAuthtype().toUpperCase().contentEquals(AuthenticationInfo.DIGEST_AUTHENTICATION)) {
				authFilter = new HTTPDigestAuthFilter(username, password);
			}

			if (authFilter == null)
				throw new RuntimeException("Invalid authentication type ");

			this.addFilter(authFilter);
		}
	}

	public WebResource resource() {
		return super.resource(mhpUri);
	}

	public WebResource patientsResource() {
		return resource().path("patients");
	}
}
