

/*____Test Duration Calculator____*/

test('Date Calculator produces proper date in the past',4, function() {  
	// On start this is visible  
	equal(produceDate(1, '05/21/2012') , '05/21/2011', '1 year in the past'); 
	equal(produceDate(1, '05/21/2012') , '05/21/2011', '1 year in the past, adds DD and MM');
	equal(produceDate(2, '05/21/2012') , '05/21/2010', '2 year in the past'); 
	equal(produceDate(2, '02/29/2012') , '03/01/2010', '2 year in the past, leap year');
});

/*____Test formatDateToDays____*/

test('Takes date object and formats it to Month Day, Year and truncates days needed',14, function() {  
	// On start this is visible  
	equal(formatDateToDays('05/21/2012') , '<span><strong>Monday</strong></span> <span>May 21, 2012</span>', 'Monday'); 
	equal(formatDateToDays('06/21/2012') , '<span><strong>Thursday</strong></span> <span>June 21, 2012</span>', 'Thursday');
	equal(formatDateToDays('11/21/2012') , '<span><strong>Wednesday</strong></span> <span>November 21, 2012</span>', 'Wednesday'); 
	equal(formatDateToDays('08/21/2012') , '<span><strong>Tuesday</strong></span> <span>August 21, 2012</span>', 'Tuesday');
	equal(formatDateToDays('09/21/2012') , '<span><strong>Friday</strong></span> <span>September 21, 2012</span>', 'Friday');
	equal(formatDateToDays('10/21/2012') , '<span><strong>Sunday</strong></span> <span>October 21, 2012</span>', 'Sunday');
	equal(formatDateToDays('04/21/2012') , '<span><strong>Saturday</strong></span> <span>April 21, 2012</span>', 'Sat');

	equal(formatDateToDays('05/21/2012', true) , '<span><strong>Mon</strong></span> <span>May 21, 2012</span>', 'Mon'); 
	equal(formatDateToDays('06/21/2012', true) , '<span><strong>Thur</strong></span> <span>June 21, 2012</span>', 'Tue');
	equal(formatDateToDays('11/21/2012', true) , '<span><strong>Wed</strong></span> <span>November 21, 2012</span>', 'Wed'); 
	equal(formatDateToDays('08/21/2012', true) , '<span><strong>Tue</strong></span> <span>August 21, 2012</span>', 'Tue');
	equal(formatDateToDays('09/21/2012', true) , '<span><strong>Fri</strong></span> <span>September 21, 2012</span>', 'Fri');
	equal(formatDateToDays('10/21/2012', true) , '<span><strong>Sun</strong></span> <span>October 21, 2012</span>', 'Sun');
	equal(formatDateToDays('04/21/2012', true) , '<span><strong>Sat</strong></span> <span>April 21, 2012</span>', 'Sat');
});
		

module('Tests for secondRequestDatesValid');
var firstRequest = new m.AppointmentRequest(),
	secondRequest = new m.AppointmentRequest();

QUnit.testStart(function() {
	firstRequest.set('optionDate1','9/7/2012');
	firstRequest.set('optionTime1', 'AM');
	firstRequest.set('optionDate2', '9/8/2012');
	firstRequest.set('optionTime2', 'AM');
	firstRequest.set('optionDate3', '9/9/2012');
	firstRequest.set('optionTime3', 'AM');

	secondRequest.set('optionDate1', firstRequest.get('optionDate1'));
	secondRequest.set('optionTime1', firstRequest.get('optionTime1'));

	secondRequest.set('optionDate2', '9/10/2012');
	secondRequest.set('optionTime2', 'AM');
	secondRequest.set('optionDate3', '9/11/2012');
	secondRequest.set('optionTime3', 'AM');
});

test('Ensure secondRequestDatesValid returns true when second request has no repeats', function() {
	firstRequest.set('optionDate1','9/7/2012');
	firstRequest.set('optionTime1', 'AM');
	firstRequest.set('optionDate2', '9/8/2012');
	firstRequest.set('optionTime2', 'AM');
	firstRequest.set('optionDate3', '9/9/2012');
	firstRequest.set('optionTime3', 'AM');

	secondRequest.set('optionDate1', firstRequest.get('optionDate1'));
	secondRequest.set('optionTime1', firstRequest.get('optionTime1'));

	secondRequest.set('optionDate2', '9/10/2012');
	secondRequest.set('optionTime2', 'AM');
	secondRequest.set('optionDate3', '9/11/2012');
	secondRequest.set('optionTime3', 'AM');

	ok(m.secondRequestDatesValid(firstRequest, secondRequest),
		'Appropriate dates are different');
});

test('Ensure secondRequestDatesValid returns false when option1 is different', function() {
	secondRequest.set('optionDate1', '9/12/2012');
	secondRequest.set('optionTime1', firstRequest.get('optionTime1'));
	equal(m.secondRequestDatesValid(firstRequest, secondRequest), false,
		'Option1 calendar dates are different');

	secondRequest.set('optionDate1', firstRequest.get('optionDate1'));
	secondRequest.set('optionTime1', 'PM');
	equal(m.secondRequestDatesValid(firstRequest, secondRequest), false,
		'Option1 times of day(am/pm) are different');
});

test('Ensure secondRequestDatesValid returns false when second request has a repeat', function() {
	secondRequest.set('optionDate2', firstRequest.get('optionDate1'));
	secondRequest.set('optionTime2', firstRequest.get('optionTime1'));
	equal(m.secondRequestDatesValid(firstRequest, secondRequest), false,
		'Second request option2 is a direct repeat of first request option1');

	secondRequest.set('optionDate3', firstRequest.get('optionDate2'));
	secondRequest.set('optionTime3', firstRequest.get('optionTime2'));
	equal(m.secondRequestDatesValid(firstRequest, secondRequest), false,
		'Second request option3 is a direct repeat of first request option2');
});

test('Ensure secondRequestDatesValid returns true when second has repeat date but not time', function() {
	secondRequest.set('optionDate2', firstRequest.get('optionDate2'));
	secondRequest.set('optionTime2', 'PM');
	ok(m.secondRequestDatesValid(firstRequest, secondRequest),
		'Second request optionDate2 is a repeat of first request optionDate2');

	firstRequest.set('optionTime3', 'PM');
	secondRequest.set('optionDate3', firstRequest.get('optionDate3'));
	ok(m.secondRequestDatesValid(firstRequest, secondRequest),
		'Second request optionDate3 is a repeat of first request optionDate3');
});
		
		