package com.agilex.healthcare.mobilehealthplatform.util;

import static org.junit.Assert.assertEquals;

import java.net.URI;

import org.junit.Test;

public class URLUtilityTest {

	@Test
	public void validateRemovingOfPort80FromURL() throws Exception{

		URI url = new URI("http://localhost:80/rest");
		String expectedUrl = "http://localhost/rest"; 
		URI updatedUrl =  URLUtility.removePort(url, 80);
		
		assertEquals(expectedUrl, updatedUrl.toString());
	}

	@Test
	public void validateRemovingOfPort80FromURLWithAdditionalAttributes() throws Exception{

		URI url = new URI("http://localhost:80/rest/80");
		String expectedUrl = "http://localhost/rest/80"; 
		URI updatedUrl =  URLUtility.removePort(url, 80);
		
		assertEquals(expectedUrl, updatedUrl.toString());
	}

	@Test
	public void validateRemovingOfPortFromURL() throws Exception{

		URI url = new URI("http://localhost:8080/rest/80");
		String expectedUrl = "http://localhost:8080/rest/80"; 
		URI updatedUrl =  URLUtility.removePort(url, 80);
		
		assertEquals(expectedUrl, updatedUrl.toString());
	}
	
	@Test
	public void validateRemovingOfPortFromURLCase2() throws Exception{

		URI url = new URI("http://localhost/rest/80");
		String expectedUrl = "http://localhost/rest/80"; 
		URI updatedUrl =  URLUtility.removePort(url, 80);
		
		assertEquals(expectedUrl, updatedUrl.toString());
	}
	
	@Test 
	public void validateRemovingStandardHttpPort() throws Exception{

		URI url = new URI("http://localhost:80/rest/80");
		String expectedUrl = "http://localhost/rest/80"; 	
		URI updatedUrl =  URLUtility.removeStandardPortsFromUri(url);
		
		assertEquals(expectedUrl, updatedUrl.toString());
	}

	@Test 
	public void validateRemovingStandardHttpPortCase2() throws Exception{

		URI url = new URI("http://localhost:443/rest/80");
		String expectedUrl = "http://localhost:443/rest/80"; 	
		URI updatedUrl =  URLUtility.removeStandardPortsFromUri(url);
		
		assertEquals(expectedUrl, updatedUrl.toString());
	}
	
	@Test 
	public void validateRemovingStandardHttpSSLPort() throws Exception{

		URI url = new URI("https://localhost:443/rest/443");
		String expectedUrl = "https://localhost/rest/443"; 
		URI updatedUrl =  URLUtility.removeStandardPortsFromUri(url);
		
		assertEquals(expectedUrl, updatedUrl.toString());
	}

	@Test 
	public void validateRemovingStandardHttpSSLPortCase2() throws Exception{

		URI url = new URI("https://localhost:80/rest/443");
		String expectedUrl = "https://localhost:80/rest/443"; 
		URI updatedUrl =  URLUtility.removeStandardPortsFromUri(url);
		
		assertEquals(expectedUrl, updatedUrl.toString());
	}

}
