package com.agilex.healthcare.mobilehealthplatform.roa;

import static org.junit.Assert.fail;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.junit.Test;

public class PNGLearningTest {
	private static final String RESOURCES_LOCATION = "src/test/resources/com/agilex/healthcare/mobilehealthplatform/roa/";
	
    @Test
    public void testOverlay() {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(RESOURCES_LOCATION + "roa.png"));
            image = process(image);

            File outputfile = new File(RESOURCES_LOCATION + "saved.png");
            ImageIO.write(image, "png", outputfile);
        } catch (IOException e) {
            e.printStackTrace();
            fail("Error generating image");
        }
    }

    private BufferedImage process(BufferedImage old) {
        int w = old.getWidth();
        int h = old.getHeight();
        BufferedImage img = new BufferedImage(
            w, h, BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2d = img.createGraphics();
        g2d.drawImage(old, 0, 0, null);
        g2d.setPaint(Color.black);
        g2d.setFont(new Font("Sans Serif", Font.PLAIN, 15));
        
        
        String name = "Lastname Firstname MI";
        g2d.drawString(name, 70, 448);
        
        String dob = "01/01/2000";
        g2d.drawString(dob, 670, 448);
        
        String date = "01/01/2012";
        g2d.drawString(date, 617, 944);
        
        g2d.dispose();
        return img;
    }
}
